
#include "p33Fxxxx.h"
#include "../sdcard/diskio.h"
#include "../sdcard/ff.h"
#include "../sdcard/spi.h"
#include "hexfile.h"
#include "flash_operations.h"
#include "../SDCard.h"
#include <string.h>

// Device configuration registers
_FGS(GWRP_OFF & GCP_OFF); // we don't want to write protect the flash
_FOSCSEL(FNOSC_FRC); // start up initially without the crystal or PLL
_FOSC(FCKSM_CSECMD & OSCIOFNC_OFF & POSCMD_HS);
_FWDT(FWDTEN_OFF); // not using the watchdog timer

unsigned char memoryCardSystemUp;

void Timer_Delay_ms_escape(unsigned short ms, unsigned char* interrupt, unsigned char interrupt_cmp) {
	do {
		unsigned short delay = ms;
		if( delay > 400 )
			delay = 400;

		TMR1 = 0;
		PR1 = 77*delay;
		IFS0bits.T1IF = 0;
		T1CONbits.TON = 1;
		while( !IFS0bits.T1IF ) {
			memoryCardSystemUp = !PORTBbits.RB11;
			if( interrupt && *interrupt == interrupt_cmp )
				return;
		}
		T1CONbits.TON = 0;
		IFS0bits.T1IF = 0;

		ms -= delay;
	} while( ms );
}

#define INIT_ATTEMPTS 3
#define INIT_DELAY    200

FATFS fs;
DIR cur_pos;
FILINFO cur_file_info;
FIL cur_file;

#define HEX_FILE_NAME "LED Musicolour.hex"

static void boot_main_program() {
	// restore state to default

	// undo pull-up for card sense pin
	CNPU1bits.CN15PUE = 0;

	// reset SPI for SD card
	SPI2STAT = 0;
	SPI2CON1 = 0;
	SPI2CON2 = 0;

	RPINR22 = 0x1F1F;
	RPOR5 = 0;
	TRISA = 0x079F;
	LATA = 0x0000;
	TRISB = 0xFFFF;
	LATB = 0x0000;
	_SPI2IF = 0;
	AD1PCFGL = 0;

	// reset DMA for SD card
	DMA2CON = 0;
	DMA2STA = 0;
	DMA2PAD = 0;
	DMA2CNT = 0;
	DMA2REQ = 0;

	// reset LED stuff
	T3CON = 0;
    PR3 = 0xFFFF;
	OC2CON = 0;
	IEC0bits.T3IE = 0;
   	IEC0bits.OC2IE = 0;

	// reset timer used for Timer_Delay_ms_escape
	T1CON = 0;
	PR1 = 0xFFFF;
	IFS0bits.T1IF = 0;
	__asm__ volatile("goto 0x200");
}

inline static void init_led() {
    TRISAbits.TRISA0 = 0;
	LATAbits.LATA0 = 1;
}
inline static void led_on() {
	LATAbits.LATA0 = 0;
}
inline static void led_off() {
	LATAbits.LATA0 = 1;
}
static void error_flash(unsigned char long_flashes, unsigned char short_flashes, unsigned char* interrupt, unsigned char interrupt_cmp) {
	unsigned char i;

	LATAbits.LATA0 = 1;

	while(!interrupt || *interrupt != interrupt_cmp) {
		for( i = 0; i < long_flashes; ++i ) {
			LATAbits.LATA0 = 0;
			Timer_Delay_ms_escape(1000, interrupt, interrupt_cmp);
			LATAbits.LATA0 = 1;
			Timer_Delay_ms_escape(1000, interrupt, interrupt_cmp);
		}
		for( i = 0; i < short_flashes; ++i ) {
			LATAbits.LATA0 = 0;
			Timer_Delay_ms_escape(300, interrupt, interrupt_cmp);
			LATAbits.LATA0 = 1;
			Timer_Delay_ms_escape(200, interrupt, interrupt_cmp);
		}
		Timer_Delay_ms_escape(2000, interrupt, interrupt_cmp);
	}
}

static unsigned char init_sdcard_and_open_hex_file() {
	unsigned char i;

	for( i = 0; i < INIT_ATTEMPTS; ++i ) {
		unsigned char result;
		Timer_Delay_ms_escape(INIT_DELAY, &memoryCardSystemUp, 0);
		result = disk_initialize(0);
		if( result != STA_NOINIT )
			break;
	}
	if( i == INIT_ATTEMPTS ) {
		return 1;
	}
	if( f_mount(0, &fs) != FR_OK ) {
		return 2;
	}
	if( f_open(&cur_file, "0:\\" HEX_FILE_NAME, FA_READ|FA_OPEN_EXISTING) != FR_OK )
		return 3;
	return 0;
}

unsigned long boot_address_cache[2];
void flash_block_erased(unsigned short addr) {
	if( addr == 0 ) {
		write_flash_word(0, boot_address_cache[0]);
		write_flash_word(2, boot_address_cache[1]);
	}
}

static void rapid_flash(unsigned short delay) {
    led_on();
	Timer_Delay_ms_escape(delay, 0, 0);
    led_off();
	Timer_Delay_ms_escape(delay, 0, 0);
}

int main(void) {
	unsigned char error, ret, i;

	// set up and switch to PLL
	PLLFBD = 41;
	CLKDIVbits.PLLPRE = 0;
	CLKDIVbits.PLLPOST = 1;
    __builtin_write_OSCCONH(0x01); // switch to FRC PLL
    __builtin_write_OSCCONL(0x01);

	sdcard_init();
//	CNPU1bits.CN15PUE = 1;

	// set up timer 0 for Timer_Delay_ms_escape
	T1CONbits.TCKPS = 3; // divided by 256;

	init_led();
	rapid_flash(200);
	rapid_flash(200);

	boot_address_cache[0] = read_program_word(0);
	boot_address_cache[1] = read_program_word(2);

	while(1) {
		memoryCardSystemUp = !PORTBbits.RB11;
		if( !memoryCardSystemUp )
			break;
		sdcard_set_power(1);
		error = init_sdcard_and_open_hex_file();
		if( error ) {
			if( error == 3 ) // no hex file detected
				break;
		Failure:
			error_flash(1, error, &memoryCardSystemUp, 0);
			while( PORTBbits.RB11 )
				;
		} else {
			ret = check_hex_file(&cur_file);
			if( ret == difference ) {
				for( i = 0; i < 10; ++i )
					rapid_flash(100);
				led_on();
				if( f_open(&cur_file, "0:\\" HEX_FILE_NAME, FA_READ|FA_OPEN_EXISTING) != FR_OK ) {
					error = 3;
					goto Failure;
				}	
				reflash_from_hex_file(&cur_file);
				led_off();
				if( f_open(&cur_file, "0:\\" HEX_FILE_NAME, FA_READ|FA_OPEN_EXISTING) != FR_OK ) {
					error = 3;
					goto Failure;
				}	
				ret = check_hex_file(&cur_file);
			}
			if( ret == no_difference ) {
				break;
			} else {
				error_flash(1, 3 + ret, &memoryCardSystemUp, 0);
				while( PORTBbits.RB11 )
					;
			}
		}
	}
	boot_main_program();

	return 0;
}
